from PyQt5.QtCore import QLineF, Qt, QRectF, QRect
from PyQt5.QtGui import QColor, QPainter
from PyQt5.QtWidgets import QWidget
from lib import constants

class SeismogramWidget(QWidget):
    HEIGHT = 200
    
    def __init__(self, slider, isForward=False, parent=None):
        super(QWidget, self).__init__(parent)
        self.setFixedHeight(SeismogramWidget.HEIGHT)
        self._original_seismogram = None
        self._current_seismogram = None
        self.slider = slider
        
        self._mode = 0
        self._isForward = isForward

    def getCurrentSeismogram(self):
        return self._current_seismogram

    def set_original_seismogram(self, seismogram):
        self._original_seismogram = seismogram
        self.update()   
        
    def set_current_seismogram(self,seismogram):
        self._current_seismogram = seismogram
        self.update()    
        
    def mousePressEvent(self, ev):
        self.slider.mousePressEvent(ev)

    def mouseMoveEvent(self, ev):
        self.slider.mouseMoveEvent(ev)
    
    def set_isForward(self, isForward):
        self._isForward = isForward
        
    def paintEvent(self, event):
        QWidget.paintEvent(self, event)

        painter = QPainter(self)
        if self._mode == 0:
            self._paintDefault(painter)
        elif self._mode == 1:
            self._paintDetail(painter)

    def _paintDefault(self, painter):
        painter.setPen(QColor(Qt.lightGray))
        x = self.slider.getHandleX()
        painter.drawLine(QLineF(x, 0, x, self.height()))
            
        if self._original_seismogram is not None:
            painter.drawImage(self.rect(), self._original_seismogram)
    
        if self._current_seismogram is not None:
            if self._isForward:
                tarRect = QRectF(self.rect())
                perc = x / float(self.slider.width())
                tarRect.setWidth(tarRect.width() * perc)
                srcRect = QRectF(self._current_seismogram.rect())
                srcRect.setWidth(srcRect.width() * perc)
                painter.drawImage(tarRect, self._current_seismogram, srcRect)
            else:
                painter.drawImage(self.rect(), self._current_seismogram)

    # TODO need images of single seismograms
    def _paintDetail(self, painter):
        if self._current_seismogram is None:
            return

        n = 3
        width = self.width() / n
        height = self.height()

        for i in range(1):
            rect = QRect(i * width, 0, width, height)
            progress = self.slider.value() / float(constants.FRAME_COUNT)
            x = progress * (self._current_seismogram.width() - rect.width())
            seismoRect = QRect(x, 0, width, height)
            painter.drawImage(rect, self._current_seismogram, seismoRect)
