from PyQt5.QtWidgets import QSlider, QStyle, QStyleOptionSlider


class JumpSlider(QSlider):
    '''
    http://stackoverflow.com/questions/11132597/qslider-mouse-direct-jump    
    '''
    def mousePressEvent(self, ev):
        """ Jump to click position """
        val = QStyle.sliderValueFromPosition(self.minimum(), self.maximum(), ev.x(), self.width())
        self.setValue(val)

    def mouseMoveEvent(self, ev):
        """ Jump to pointer position while moving """
        val = QStyle.sliderValueFromPosition(self.minimum(), self.maximum(), ev.x(), self.width())
        self.setValue(val)

    def getHandleX(self):
        '''        
        https://stackoverflow.com/questions/31653647/how-to-make-a-tip-to-follow-the-handler-of-slider-with-pyqt
        '''
        opt = QStyleOptionSlider()
        self.initStyleOption(opt)
        rectHandle = self.style().subControlRect(QStyle.CC_Slider, opt, QStyle.SC_SliderHandle, self)
        return rectHandle.center().x()


class InversionSlider(QSlider):
    def __init__(self, *args, **kwargs):
        QSlider.__init__(self, *args, **kwargs)
        self.setTickInterval(1)
        self.setPageStep(1)        
        # TODO do it prettier...
        nothing = lambda e: None
        self.mouseMoveEvent = nothing
        self.mousePressEvent = nothing
        self.wheelEvent = nothing
    
    def getHandleX(self):
        '''        
        https://stackoverflow.com/questions/31653647/how-to-make-a-tip-to-follow-the-handler-of-slider-with-pyqt
        '''
        opt = QStyleOptionSlider()
        self.initStyleOption(opt)
        rectHandle = self.style().subControlRect(QStyle.CC_Slider, opt, QStyle.SC_SliderHandle, self)
        return rectHandle.center().x()
