from PyQt5.QtCore import QSize, Qt
from PyQt5.QtGui import QFont, QImage, QPainter, QPalette
from PyQt5.QtWidgets import QWidget

from lib.constants import Orientation, ResPath
from util import renderutil
from widgets.materialeditor.dragobject import DragObject


class ReceiverPlacement(QWidget):
    def __init__(self, parent=None):
        super(QWidget, self).__init__(parent)
        
        palette = QPalette()
        palette.setColor(QPalette.Background, Qt.white)
        self.setPalette(palette)
        self._bg = QImage(ResPath.textures + "water.png")

        self._receivers_count = 19
        self._receivers = DragObject(self, xrel=0.5, orientation=Orientation.HORIZONTAL)
        receiverImage = QImage(ResPath.textures + "receiver.png")
        self.receiversHeight = 20
        self.receiversTextHeight = 30
        receiversWidth = receiverImage.width() * self.receiversHeight // receiverImage.height() * self._receivers_count
        self._receivers.setFixedSize(QSize(receiversWidth, self.receiversHeight + self.receiversTextHeight))
        size = QSize(receiversWidth, self.receiversHeight)        
        image = renderutil.createFilledImage(receiverImage, size , tilesX=self._receivers_count, tilesY=1)
        
        number_image = QImage(receiversWidth, self.receiversTextHeight, image.format())
        number_image.fill(0)
        numbers_rect = number_image.rect()
        
        painter = QPainter(number_image)
        painter.setPen(Qt.white)
        painter.setFont(QFont("Times", 14, QFont.Bold))
        painter.drawText(numbers_rect, Qt.AlignLeft, " 1")
        painter.drawText(numbers_rect, Qt.AlignCenter, str((self._receivers_count + 1) // 2))
        painter.drawText(numbers_rect, Qt.AlignRight, str(self._receivers_count))
        painter.end()
        
        image = renderutil.mergeImages([image, number_image])
        self._receivers.setImage(image)

    def getCenterX(self):
        return self._receivers.xrel

    def setCenterX(self, centerX):
        self._receivers.xrel = centerX
        reciever_xpos = self._receivers.xrel * self.width() - self._receivers.width() / 2
        self._receivers.move(reciever_xpos, self._receivers.y())

    def setDraggable(self, draggable):
        self._receivers.setDraggable(draggable)

    def paintEvent(self, event):
        QWidget.paintEvent(self, event)
        painter = QPainter(self)
        #painter.setOpacity(0.8)
        painter.drawImage(self.rect(),self._bg)

    def relReceiversPositions(self):
        rel_x_left = float(self._receivers.x()) / self.width()
        rel_x_right = float(self._receivers.x() + self._receivers.width()) / self.width()
        rel_receiver_width = (rel_x_right - rel_x_left) / self._receivers_count
        rel_receivers_xs = [rel_x_left + rel_receiver_width * (0.5 + i) for i in xrange(self._receivers_count)]
        y = float(self.receiversHeight) / (2 * self.height())

        return [(rel_x, y) for rel_x in rel_receivers_xs]
    
    def resizeEvent(self, event):
#         diff_w = event.oldSize().width() - event.size().width()

        reciever_xpos = self._receivers.xrel * event.size().width() - self._receivers.width() / 2
        self._receivers.move(reciever_xpos, self._receivers.y())
