from PyQt5.QtCore import QSize, Qt
from PyQt5.QtGui import QImage, QPalette
from PyQt5.QtWidgets import QWidget

from lib.constants import Orientation, ResPath
from widgets.materialeditor.dragobject import DragObject


class EmitterPlacement(QWidget):
    SHIP_HEIGHT = 40

    def __init__(self, parent=None):
        super(QWidget, self).__init__(parent)
        
        palette = QPalette()
        palette.setColor(QPalette.Background, Qt.white)
        # setAutoFillBackground(True)
        self.setPalette(palette)
        self._emitter = DragObject(self, xrel=0.45, orientation=Orientation.HORIZONTAL)
        emitterImg = QImage(ResPath.textures + "boat.png")
        emitterWidth = EmitterPlacement.SHIP_HEIGHT * emitterImg.width() // emitterImg.height()
        self._emitter.setFixedSize(QSize(emitterWidth, EmitterPlacement.SHIP_HEIGHT))
        self._emitter.setImage(emitterImg)
        self.setFixedHeight(EmitterPlacement.SHIP_HEIGHT)
        
    def getCenterX(self):
        return self._emitter.xrel
    
    def setCenterX(self, centerX):
        self._emitter.xrel = centerX
        emitter_xpos = self._emitter.xrel * self.width() - self._emitter.width() / 2            
        self._emitter.move(emitter_xpos, self._emitter.y())
    
    def relEmitterPosition(self):
        return (self.getCenterX(), 0.5)

    def setDraggable(self, draggable):
        self._emitter.setDraggable(draggable)

    def resizeEvent(self, event):
        emitter_xpos = self._emitter.xrel * event.size().width() - self._emitter.width() / 2            
        self._emitter.move(emitter_xpos, self._emitter.y())
