from PyQt5.QtCore import Qt
from PyQt5.QtGui import QPixmap
from PyQt5.QtWidgets import QLabel, QSizePolicy

from lib.constants import ResPath
from lib.i18n import luDir


class CreditsLabel(QLabel):
    def __init__(self, parent=None):
        QLabel.__init__(self, parent=parent)
        
        self.setScaledContents(False)
        self.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)

        self._pix = QPixmap(luDir(ResPath.documentation) + "credits.png")
        self.setPixmap(self._pix)

    def resizeEvent(self, event):
        QLabel.resizeEvent(self, event)
        
        if not self._pix.isNull():
            self.setPixmap(self._pix.scaled(self.size(), aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation))
            
    def reset(self):
        pass
    