from PyQt5.QtWidgets import QBoxLayout, QSpacerItem, QWidget


class _AspectRatioContainer(QWidget):
    def __init__(self, aspectRatio, parent=None):
        QWidget.__init__(self, parent=parent)

        self.setLayout(QBoxLayout(QBoxLayout.LeftToRight, parent=self))
        self.layout().setContentsMargins(0, 0, 0, 0)
        self.layout().setSpacing(0)

        self._aspectRatio = aspectRatio

    def resizeEvent(self, event):
        aspectRatio = event.size().width() / float(event.size().height())

        # too wide
        if aspectRatio > self._aspectRatio:
            self.layout().setDirection(QBoxLayout.LeftToRight)
            widgetStretch = self.height() * self._aspectRatio
            outerStretch = self.width() - widgetStretch + 0.5
        # too tall
        else:
            self.layout().setDirection(QBoxLayout.TopToBottom)
            widgetStretch = self.width() / self._aspectRatio
            outerStretch = self.height() - widgetStretch + 0.5

        self.layout().setStretch(0, widgetStretch)
        self.layout().setStretch(1, outerStretch)

    
class AspectRatioWidgetContainer(_AspectRatioContainer):
    """
    A container widget to keep the aspect ratio (width : height) of a widget. The widget will always be on the upper left and resize when possible.
    """
    def __init__(self, widget, aspectRatio, parent=None):
        _AspectRatioContainer.__init__(self, aspectRatio, parent=parent)

        # add widget, then spacer
        self.layout().addWidget(widget)
        self.layout().addItem(QSpacerItem(0, 0))


class AspectRatioLayoutContainer(_AspectRatioContainer):
    """
    A container widget to keep the aspect ratio (width : height) of a widget. The widget will always be on the upper left and resize when possible.
    """
    def __init__(self, layout, aspectRatio, parent=None):
        _AspectRatioContainer.__init__(self, aspectRatio, parent=parent)

        # add layout, then spacer
        self.layout().addLayout(layout)
        self.layout().addItem(QSpacerItem(0, 0))
