import cStringIO
import sys
import traceback


def excepthook(excType, excValue, tracebackobj):
    """
    Global function to catch unhandled exceptions.
    @param excType exception type
    @param excValue exception value
    @param tracebackobj traceback object
    """
    separator = '-' * 80

    tbinfofile = cStringIO.StringIO()
    traceback.print_tb(tracebackobj, None, tbinfofile)
    tbinfofile.seek(0)
    tbinfo = tbinfofile.read()
    errmsg = '%s: \n%s' % (str(excType), str(excValue))
    sections = [separator, errmsg, separator, tbinfo]
    msg = '\n'.join(sections)
#     try:
#         f = open(logFile, "w")
#         f.write(msg)
#         f.write(versionInfo)
#         f.close()
#     except IOError:
#         pass
    sys.exit(str(msg))

def clamp(value, lower, upper):
    """
    clamps a value into [lower, upper]
    @param value: the value to clamp
    @param lower: the lower boundary for value
    @param upper: the upper boundary for value
    """
    return min(max(value, lower), upper)

def _capitalize(word):
    """helper method for toCamelCase(...)"""
    if not word:
        return word
    else:
        return word[0].upper() + word[1:]

def toCamelCase(string):
    """
    makes a string camelCase.
    @param string: arbitary string
    @return: the input string in camelCase format
    """
    words = string.split()
    words = [words[0]] + [_capitalize(word) for word in words[1:]]
    return "".join(words)

def isIterable(obj):
    """return true if *obj* is iterable"""
    try:
        iter(obj)
    except TypeError:
        return False
    return True
