import numpy as np
from PyQt5.QtGui import QImage
from util import renderutil, utils


def colorBars():
    import matplotlib
    matplotlib.use("Agg")
    import matplotlib.pyplot as plt
    from util.colormaps import CenteredColorMap

    def showColorBar(colormap, norm):
        sm = plt.cm.ScalarMappable(cmap=colormap, norm=norm)
        sm._A = []
        bar = plt.colorbar(sm)
        name = colormap if type(colormap) is str else colormap.name
        bar.set_label(name)
        return bar

    data = np.linspace(-5, 10, 1000, dtype="float64")
    
    cMin, cMax = min([d.min() for d in data]), max([d.max() for d in data])
    mid = abs(cMin) / (cMax - cMin)
    
    fig = plt.figure()
    fig.patch.set_alpha(0.0)
    plt.gca().patch.set_alpha(0.0)
    
    norm = plt.Normalize(vmin=cMin, vmax=cMax)
    
    showColorBar("RdGy", norm)
    
    gradient = ((0.0, 0.0, 0.0), (mid, 1.0, 1.0), (1.0, 0.0, 0.0))
    cDict = dict.fromkeys(("red", "green", "blue"), gradient)
    colormap = matplotlib.cm.colors.LinearSegmentedColormap("binaryNormed", cDict, 1024)
    matplotlib.cm.register_cmap(cmap=colormap)
    showColorBar(colormap, norm)
    
    showColorBar(CenteredColorMap(mid, (1, 0, 0, 1), (1, 0, 0, 0), (0, 0, 1, 0), (0, 0, 1, 1), stretch=0.75), norm)
    
    showColorBar(CenteredColorMap(mid, (1, 0, 0, 1), (0, 0, 0, 0), (0, 0, 0, 0), (0, 0, 1, 1)), norm)
    
#     plt.show()
    
    plt.draw()
    argb_data = bytes(fig.canvas.buffer_rgba())
    qImage = QImage(argb_data, fig.canvas.renderer.width, fig.canvas.renderer.height, QImage.Format_ARGB32)
    renderutil.qImageToPillow(qImage).save("../tmp/bars.png")


#     colorBars()


def test():
    import matplotlib
    matplotlib.use("Agg")
    import matplotlib.pyplot as plt
    fig = plt.figure()
    fig.patch.set_alpha(0.0)
    
    ax = fig.add_axes([0, 0, 1, 1])
    ax.set_axis_off()
    ax.patch.set_alpha(0.0)
    array = np.ones(100)
    ax.plot(array, color="red", linewidth=1)
    ax.plot(array*0.5, color="green", linewidth=1)
    ax.plot(array*0, color="blue", linewidth=1)
    
#     plt.show()
    plt.draw()
    argb_data = bytes(fig.canvas.buffer_rgba())
    plt.close(fig)

#     qImage = QImage(argb_data, fig.canvas.renderer.width, fig.canvas.renderer.height, QImage.Format_ARGB32)
    qImage = QImage(argb_data, fig.canvas.renderer.width, fig.canvas.renderer.height, QImage.Format_RGBA8888)
    renderutil.qImageToPillow(qImage).show()

a = [1, 2, 3, 4, 5]
print a
for i in a[:]:
    if i > 2:
        a.remove(i)
print a
