from __future__ import print_function

import time
import os
import signal
from multiprocessing import Process, Event
from multiprocessing.queues import Queue, Empty

import threading
import random

import thread # python2 only

class MyQueue(Queue):
    def clear(self):
        try:
            while True:
                a = self.get_nowait()
                print("Discarding '{}'".format(a))
        except Empty:
            pass


class MyProcess(Process):    
    def __init__(self, interrupt_event, q):
        self.interrupt_event = interrupt_event
        self.q = q
        self.reset_counter = 0
        Process.__init__(self)
    
    def _interrupt_handler(self):
        print(os.getpid(), "Wait for event")
        self.interrupt_event.wait()
        print(os.getpid(), "Main process wants us to reset")
        thread.interrupt_main()
        
    def hard_work(self):
        while True:
            time.sleep(0.2)
            self.q.put("Run {}".format(self.reset_counter))
        
    def run(self):
        while True:
            try:
                task = threading.Thread(target=self._interrupt_handler)
                task.start()
                self.hard_work()
            except KeyboardInterrupt:
                print(os.getpid(), "Stopped by event - resetting...")
                self.interrupt_event.clear()
                self.reset_counter += 1


if __name__ == "__main__":
    print("Main program")
    
    interrupt_event = Event()
    q = MyQueue()
    
    p = MyProcess(interrupt_event, q)
    p.start()
    
    for i in range(3):
        try:
            print()
            t = 0.2 + 2*random.random()
            print("Main process waiting for {:.3f} seconds".format(t))
            time.sleep(t)
            print("Main process waiting done: resetting child")
            
            print("Example result:", q.get())
            q.clear()
            
            interrupt_event.set()
        except KeyboardInterrupt:
            print("Stopping main program")
            break
        
    p.terminate()
    p.join()
    print("Finished")
