from PyQt5.QtWidgets import QApplication, QWidget
from PyQt5.QtGui import QPainter
from parallel.computationmanager import ComputationManager
from PyQt5.QtCore import Qt
import numpy as np
import sys
from lib import constants
from util import utils


class Widget(QWidget):
    def __init__(self, manager):
        QWidget.__init__(self)
        self.resize(1200, 700)
        
        self.manager = manager
        self.queue = None
        
        self.timerId = None
        self.frame = 0
        self.image = None

    def timerEvent(self, event):
        if self.frame < constants.FRAME_COUNT:
            if self.queue and not self.queue.empty():
                self.image, seismoImage, seismoData = self.queue.get()
                self.frame += 1
                self.update()
        else:
            print "finished forward animation"
            self.killTimer(self.timerId)

    def paintEvent(self, event):
        if self.image:
            painter = QPainter(self)
            painter.drawImage(self.rect(), self.image)

    def keyPressEvent(self, event):
        if event.key() == Qt.Key_F:
            source_pos = (40.13251783893986, 6.477272727272727)
            receiver_pos = [(52.330275229357795, 4.534090909090909), (55.869520897043834, 4.534090909090909), (59.408766564729866, 4.534090909090909), (62.9480122324159, 4.534090909090909), (66.48725790010194, 4.534090909090909), (70.02650356778797, 4.534090909090909), (73.56574923547402, 4.534090909090909)]    
            self._materialImage = 10 * np.ones(gridSize)
            self._materialImage[50, 35] = 2.0

            self.queue = self.manager.solveForward(source_pos, receiver_pos, self._materialImage)
            self.timerId = self.startTimer(40)
        elif event.key() == Qt.Key_I:
            material = 10 * np.ones(gridSize)
            material[50, 35] = 2.0
            queue = self.manager.solveInversion(material)

if __name__ == "__main__":
    sys.excepthook = utils.excepthook
    app = QApplication(sys.argv)

    gridSize = (100, 70)
    manager = ComputationManager(gridSize)
    widget = Widget(manager)
    
    widget.show()
    manager.start()
    sys.exit(app.exec_())
    manager.terminate
