from multiprocessing import Queue


class _Connection():
    """
    A multiprocessing.Queue-based Connection 
    """
    def __init__(self, senderQueue, receiverQueue):
        self._senderQueue = senderQueue
        self._receiverQueue = receiverQueue

    def send(self, data):
        self._receiverQueue.put(data)

    def recv(self):
        return self._senderQueue.get()

def Pipe():
    parentQueue = Queue()
    childQueue = Queue()
    parentConnection = _Connection(parentQueue, childQueue)
    childConnection = _Connection(childQueue, parentQueue)
    
    return parentConnection, childConnection
