import copy_reg
import types
import platform
import multiprocessing

def _pickle_method(m):
    if m.im_self is None:
        return getattr, (m.im_class, m.im_func.func_name)
    else:
        return getattr, (m.im_self, m.im_func.func_name)

copy_reg.pickle(types.MethodType, _pickle_method)

def parseCommandlineArguments():
    from argparse import ArgumentParser
    parser = ArgumentParser(description="Playground for Full Waveform Inversion (FWI)")
    parser.add_argument("-b", "--beamer", action="store_true", help="start in presentation mode")
    parsedArgs, unparsedArgs = parser.parse_known_args()
    return sys.argv[:1] + unparsedArgs, parsedArgs


if __name__ == '__main__':
    if platform.system() == "Windows":
        multiprocessing.freeze_support() # prevent .exe from pyinstaller to start unlimited processes. TODO: check if this even works
    
    import sys
    from util import utils
    import instance

    # to show exceptions from Qt after crash
    sys.excepthook = utils.excepthook
    
    # parse program arguments and save them in instance
    qtArgs, programArgs = parseCommandlineArguments()
    instance.preInit(programArgs)

    import app
    import ctypes

    # TODO: benchmark
    
    # create the QApplication
    application = app.Application(qtArgs)
    instance.createInstance(application) # create the instance for static access

    # tell windows that pythonw.exe is just a host for this app, so that the correct icon is shown in the task bar
    if platform.system() == "Windows":
        appId = u'kit_ianm.fwi_competition'  # arbitrary string
        ctypes.windll.shell32.SetCurrentProcessExplicitAppUserModelID(appId)

    # create the main window
    window = app.Window()
    application.postInit(window)
    window.show()
    exitCode = application.exec_()
    instance.computationManager().terminateProcess()
    sys.exit(exitCode)
