from lib.constants import ResPath
from util import utils
import os
import multiprocessing
from util.decorators import printcaller
from lib import constants


def loadLanguage(language):
    print "loading language '"+language+"' from '" + ResPath.lang+language+".lang'"
    parsedWords = {}
    with open(ResPath.lang + language + ".lang", "r") as f:
        for line in f:
            line = line.strip().decode("string_escape") # read strings from files get escaped
            if line and not line.startswith("#"):
                key, value = line.split("=")
                if key and value:
                    parsedWords[key] = value
    return parsedWords

def lu(key):
    """
    Lookup for the given key in the currently loaded language.
    """
    camelKey = utils.toCamelCase(key)
    if camelKey not in dictionary:
        dictionary[camelKey] = "?{}?".format(key)
        
        if constants.DEBUG:
            @printcaller(start=1, recursions=2)
            def printHelper():
                print "#MISSING TRANSLATION# no translation found for key '{}' ('{}')".format(camelKey, key)
            printHelper()
        else:
            print "#MISSING TRANSLATION# no translation found for key '{}' ('{}')".format(camelKey, key)

    return dictionary[camelKey]

def luDir(path):
    """
    appends the directory name for the currently loaded language to the given path.
    @param path: a string representing a directory
    """
    return os.path.join(path, language, "")

def saveDummyFile():
    outputFilePath = ResPath.lang + "dummy.txt"
    
    with open(outputFilePath, "w") as outputFile:   
        for key in sorted(dictionary.keys()):
            outputFile.write("{}=\n".format(key))
            
    print("Wrote dummyFile at: "+ outputFilePath)


# not perfect, but it works: give all other Processes own names:
dictionary = {}
if multiprocessing.current_process().name == "MainProcess":
    language = "en_us"
    dictionary = loadLanguage(language)
