import os

DEFAULT_WIDTH = 1600
DEFAULT_HEIGHT = 900
MAX_IDLE_TIME = 5 * 60 * 1000   # idle time (in milliseconds) (here 5 min)
IDLE_WARNING_TIME = 15 * 1000       # time to react after the idle time has passed

WATER_TO_MAT_RATIO = 1 / 4.0 # ratio from water to material (canvas). TODO: test ratios
COLOR_MATERIAL = (128, 122, 111)
COLOR_BACKGROUND = (196, 178, 109)

DEBUG = False

#===============================================================================
# simulation constants
#===============================================================================
MAX_INV_ITERATIONS = 2
MAGIC_INV_STEP_SIZE_FACTOR = 10
CMAP_AMP_FACTOR = 5

FRAME_COUNT = 100
DEFAULT_TIME_RANGE = 10
TOTAL_GRID_SIZE = 7000
# material values
DEFAULT_BACKGROUND_VELOCITY = 1.0
WATER_MATERIAL = 10
BACKGROUND_MATERIAL = 13
MATERTIAL_VALUE = 30


class ResPath():
    icons = os.path.join("..", "res", "icons", "")
    textures = os.path.join("..", "res", "textures", "")
    examples = os.path.join("..", "res", "examples", "")
    documentation = os.path.join("..", "res", "doc", "")
    lang = os.path.join("..", "res", "lang", "")
    tmp = os.path.join("..", "tmp", "")

class Orientation():
    HORIZONTAL = 1
    VERTICAL = 2
    BOTH = HORIZONTAL | VERTICAL
