_args = None
_app = None
_computationManager = None

def preInit(programArgs):
    global _args
    _args = programArgs

def createInstance(app):
    global _app, _computationManager
    # set current application instance
    _app = app

    # create computation manager and process
    from lib import pysit_interface
    from parallel.computationmanager import ComputationManager
    gridSize = pysit_interface.getGridResolution(getMaterialAspectRatio())
    _computationManager = ComputationManager(gridSize)
    _computationManager.start()

def args():
    return _args
  
def app():
    return _app

def window():
    return _app._window

def computationManager():
    return _computationManager

def getMaterialAspectRatio():
    # TODO calculate better AR for canvas
    if _args.beamer:
        return _app.getAspectRatio() * 1.5
    else:
        return _app.getAspectRatio()