# PyFWI

## Overview

PyFWI is an interactive software to demonstrate how subsurface material
structures like offshore oil or gas reservoirs can be found without digging or
drilling holes.  It is possible to record wave signals on the surface
(e.g. the water surface of the sea) that have traveled through the unknown
material inside the earth.  These waves have been reflected and scattered at
the interfaces of different materials and thus contain information of spacial
material structure. The approach of Full Waveform Inversion (FWI) uses a
mathematical model for wave propagation to to reproduce the obtained
measurements numerically to get an estimate of the material distribution
inside the earth. Mathematically, FWI solves a parameter identification
problem for a wave equation.

This software is intended to make the user experience the relation of surface
measurements and material structures by providing an interactive playground to
design custom materials and simulate waves inside of them.  Here, the material
can be drawn using a mouse or touch-screen and the time evolution of the
corresponding wave solution is visualized.  Further, also the inverse problem
can be experienced at least for simple toy examples. In this mode, the
numerical algorithm is visualized showing forward and backward waves one after
another.

The program features an online documentation that provides a tutorial for the
program interface and gives insights into the mathematical and numerical
realization of its internals.

## Installation 

### System requirements

As the numerical calculations are performed in real time, a decent CPU and
also RAM are required.  Our test setup was an Intel Core i7-4910MQ with more
than 8Gb of memory. However, the software should also run on less potent
hardware, but it might be slow...

PyFWI runs on Linux, OSX and Windows. 
Please note that in its current state, PyFWI runs best on a Linux desktop.

We suggest installing the Python2 variant of the Anaconda Python distribution
that can be downloaded at https://www.continuum.io/downloads 
This works for all major operating systems and delivers most of the software
we need to run PyFWI and is easy to install (even without root permissions).

On the software side Python 2.7 is required featuring following modules:
   * pysit (we tested with version 0.5b3)

   * PyQt5 (included in Anaconda)
   * numpy (included in Anaconda)
   * scipy (included in Anaconda)
   * matplotlib (included in Anaconda)
   * pillow (included in Anaconda)

Note: On Windows, the Visual Studio Compiler is required 
(http://aka.ms/vcpython27 ) to build pyamg (a dependency of pysit).

Note: Make sure, that you use the newest version of Anaconda by running

   $ conda update --all

Using the shell on Linux/OSX and the command line (Anaconda Prompt) on
Windows, the packages can be installed using pip:

   $ pip install pysit

(Make sure, Anaconda's pip is used. By default it is located at $USER/anaconda2/bin/pip )

## Running PyFWI

To run PyFWI, open the file src/main.py with the Python interpreter.
On Linux/OSX this can be done from the shell or the command line on Windows using

   $ python main.py

inside of the src directory of PyFWI.
(Make sure, Anaconda's python is used. By default it is located at $USER/anaconda2/bin/python )

## Command line arguments / startup parameters

PyFWI also has some additional features, which are accessable via startup parameters. To get a full list of those run

	$ python main.py --help

For example the presentation mode can be started by running

	$ python main.py --beamer